//GEMINI-pro DATASET v1.0 Category: Percolation Simulator ; Style: high level of detail
#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>
#define N 10

// Grid of cells
bool grid[N][N];

// Check if a cell is open
bool is_open(int x, int y) {
    return grid[x][y];
}

// Open a cell
void open_cell(int x, int y) {
    grid[x][y] = true;
}

// Check if a cell is connected to the top of the grid
bool is_connected_to_top(int x, int y) {
    if (y == 0) {
        return true;
    } else {
        return is_open(x, y) && is_connected_to_top(x, y - 1);
    }
}

// Check if a cell is connected to the bottom of the grid
bool is_connected_to_bottom(int x, int y) {
    if (y == N - 1) {
        return true;
    } else {
        return is_open(x, y) && is_connected_to_bottom(x, y + 1);
    }
}

// Check if a cell is part of a percolating cluster
bool is_percolating(int x, int y) {
    return is_connected_to_top(x, y) && is_connected_to_bottom(x, y);
}

// Main function
int main() {
    // Initialize the grid
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            grid[i][j] = false;
        }
    }

    // Open some cells
    open_cell(0, 0);
    open_cell(1, 1);
    open_cell(2, 2);
    open_cell(3, 3);
    open_cell(4, 4);

    // Check if the grid percolates
    bool percolates = false;
    for (int i = 0; i < N; i++) {
        if (is_percolating(i, N - 1)) {
            percolates = true;
            break;
        }
    }

    // Print the result
    if (percolates) {
        printf("The grid percolates.\n");
    } else {
        printf("The grid does not percolate.\n");
    }

    return 0;
}