//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#define MY_KEY 0x1234

int main() {
  int shmid;
  int pid;
  char *shmem;

  // Create shared memory segment
  shmid = shmget(MY_KEY, 1024, IPC_CREAT | 0666);
  if (shmid < 0) {
    perror("shmget");
    exit(1);
  }

  // Map shared memory segment to our process
  shmem = shmat(shmid, NULL, 0);
  if (shmem == (void *)-1) {
    perror("shmat");
    exit(1);
  }

  // Fork a child process
  pid = fork();
  if (pid < 0) {
    perror("fork");
    exit(1);
  }

  if (pid == 0) {
    // Child process
    printf("Child process writing to shared memory...\n");
    sprintf(shmem, "Hello from the child process!");
    exit(0);
  } else {
    // Parent process
    printf("Parent process waiting for child process to write to shared memory...\n");
    sleep(1);
    printf("Shared memory contains: %s\n", shmem);
  }

  // Unmap shared memory segment from our process
  shmdt(shmem);

  // Deallocate shared memory segment
  shmctl(shmid, IPC_RMID, NULL);

  return 0;
}