//LLAMA2-13B DATASET v1.0 Category: String manipulation ; Style: protected
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAX_STR_LEN 1024

// Function to reverse a string
void reverse_string(char *str) {
    int i, j;
    char temp;

    // Reverse the string by swapping each character with its last character
    for (i = 0, j = strlen(str) - 1; i < j; i++, j--) {
        temp = str[i];
        str[i] = str[j];
        str[j] = temp;
    }
}

// Function to find the first occurrence of a substring
char *find_first_occurrence(char *haystack, char *needle) {
    int i, j;

    // Search the haystack for the first occurrence of the needle
    for (i = 0, j = strlen(haystack) - strlen(needle) + 1; i < j; i++) {
        if (memcmp(haystack + i, needle, strlen(needle)) == 0) {
            return haystack + i;
        }
    }

    // If the needle is not found, return a null pointer
    return NULL;
}

// Function to count the number of occurrences of a substring
int count_occurrences(char *haystack, char *needle) {
    int i, count = 0;

    // Search the haystack for the first occurrence of the needle
    for (i = 0; i < strlen(haystack); i++) {
        if (memcmp(haystack + i, needle, strlen(needle)) == 0) {
            count++;
        }
    }

    return count;
}

int main() {
    char str[] = "This is a sample string with multiple words";
    char word[] = "word";
    char *ptr;

    // Reverse the string
    reverse_string(str);

    // Find the first occurrence of the word "word"
    ptr = find_first_occurrence(str, word);
    if (ptr != NULL) {
        printf("The first occurrence of 'word' is at position %d\n", ptr - str);
    } else {
        printf("The word 'word' is not found in the string\n");
    }

    // Count the number of occurrences of the word "word"
    int count = count_occurrences(str, word);
    printf("The word 'word' occurs %d times in the string\n", count);

    return 0;
}