//Falcon-180B DATASET v1.0 Category: TCP/IP Programming ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT "8080"
#define SERVER "127.0.0.1"
#define MAX 1024

// Function to connect to server
int connect_to_server() {
    int sockfd;
    struct sockaddr_in serv_addr;
    char buffer[MAX];

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        printf("Error: Unable to create socket\n");
        exit(0);
    }

    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(atoi(PORT));
    inet_pton(AF_INET, SERVER, &serv_addr.sin_addr);

    if (connect(sockfd, (struct sockaddr*)&serv_addr, sizeof(serv_addr)) < 0) {
        printf("Error: Unable to connect to server\n");
        exit(0);
    }

    printf("Connected to server\n");
    return sockfd;
}

// Function to send data to server
void send_data(int sockfd, char* data) {
    send(sockfd, data, strlen(data), 0);
}

// Function to receive data from server
void receive_data(int sockfd, char* buffer) {
    memset(buffer, '\0', MAX);
    int bytes_received = recv(sockfd, buffer, MAX, 0);
    if (bytes_received <= 0) {
        printf("Error: Unable to receive data\n");
        exit(0);
    }
    printf("Received data: %s\n", buffer);
}

// Main function
int main() {
    int sockfd;
    char buffer[MAX];

    // Connect to server
    sockfd = connect_to_server();

    // Send data to server
    send_data(sockfd, "Hello, World!");

    // Receive data from server
    receive_data(sockfd, buffer);

    // Close connection
    close(sockfd);

    return 0;
}