//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOULS 5

typedef struct Ghost {
    char name[20];
    int room;
    int health;
    int action;
} Ghost;

Ghost ghosts[MAX_GHOULS] = {
    {"Mr. Jones", 1, 100, 0},
    {"Mrs. Smith", 2, 80, 1},
    {"The Ghost of Christmas Past", 3, 60, 2},
    {"Mr. Brown", 4, 40, 3},
    {"The Bloody Bride", 5, 20, 4}
};

void generate_noise(int volume) {
    for (int i = 0; i < volume; i++) {
        printf("%c", rand() % 2);
    }
    printf("\n");
}

void haunt_house(Ghost *ghost) {
    switch (ghost->action) {
        case 0:
            printf("%s has moved to room %d.\n", ghost->name, ghost->room);
            generate_noise(ghost->health);
            break;
        case 1:
            printf("%s has attacked!\n", ghost->name);
            generate_noise(ghost->health);
            break;
        case 2:
            printf("%s has spoken.\n", ghost->name);
            generate_noise(ghost->health);
            break;
        default:
            break;
    }
}

int main() {
    srand(time(NULL));

    for (int i = 0; i < MAX_GHOULS; i++) {
        haunt_house(&ghosts[i]);
    }

    return 0;
}