//Falcon-180B DATASET v1.0 Category: Product Inventory System ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 1000
#define MAX_NAME_LENGTH 100

typedef struct {
    char name[MAX_NAME_LENGTH];
    int quantity;
    float price;
} item_t;

item_t inventory[MAX_ITEMS];
int num_items = 0;

void add_item(char* name, int quantity, float price) {
    if (num_items >= MAX_ITEMS) {
        printf("Error: Inventory is full.\n");
        return;
    }

    strcpy(inventory[num_items].name, name);
    inventory[num_items].quantity = quantity;
    inventory[num_items].price = price;

    num_items++;
}

void remove_item(char* name) {
    int i;

    for (i = 0; i < num_items; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            num_items--;

            if (i < num_items) {
                memmove(&inventory[i], &inventory[i+1], sizeof(item_t));
            }

            break;
        }
    }
}

void update_item(char* name, int quantity, float price) {
    int i;

    for (i = 0; i < num_items; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            inventory[i].quantity = quantity;
            inventory[i].price = price;

            break;
        }
    }
}

void print_inventory() {
    int i;

    printf("Inventory:\n");

    for (i = 0; i < num_items; i++) {
        printf("%s - %d units - $%.2f\n", inventory[i].name, inventory[i].quantity, inventory[i].price);
    }
}

int main() {
    add_item("Widget", 100, 5.99);
    add_item("Gadget", 50, 9.99);
    add_item("Doodad", 25, 2.99);

    print_inventory();

    update_item("Widget", 75, 6.99);

    print_inventory();

    remove_item("Doodad");

    print_inventory();

    return 0;
}