//Falcon-180B DATASET v1.0 Category: Game ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PLAYERS 4
#define MAX_ROUNDS 5
#define WINNING_SCORE 3

typedef struct {
    char name[20];
    int score;
} Player;

void init_game(Player* players) {
    for (int i = 0; i < MAX_PLAYERS; i++) {
        players[i].score = 0;
        sprintf(players[i].name, "Player %d", i + 1);
    }
}

void print_scoreboard(Player* players) {
    printf("Scoreboard:\n");
    for (int i = 0; i < MAX_PLAYERS; i++) {
        printf("%s: %d\n", players[i].name, players[i].score);
    }
}

void play_round(Player* players, int round_num) {
    int player1_score = rand() % 6 + 1;
    int player2_score = rand() % 6 + 1;
    players[0].score += player1_score;
    players[1].score += player2_score;

    printf("Round %d: %s rolled %d, %s rolled %d\n", round_num, players[0].name, player1_score, players[1].name, player2_score);

    if (players[0].score >= WINNING_SCORE || players[1].score >= WINNING_SCORE) {
        printf("Game over! %s wins!\n", (players[0].score >= WINNING_SCORE? players[0].name : players[1].name));
        exit(0);
    }
}

int main() {
    srand(time(NULL));

    Player players[MAX_PLAYERS];
    init_game(players);

    int round_num = 1;
    while (round_num <= MAX_ROUNDS) {
        play_round(players, round_num);
        print_scoreboard(players);
        round_num++;
    }

    return 0;
}