//Falcon-180B DATASET v1.0 Category: Temperature monitor ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SENSORS 10
#define SENSOR_NAME_LEN 16

typedef struct {
    char name[SENSOR_NAME_LEN];
    double temperature;
} sensor_t;

int num_sensors = 0;
sensor_t sensors[MAX_SENSORS];

void add_sensor(char* name) {
    if (num_sensors >= MAX_SENSORS) {
        printf("Error: Maximum number of sensors reached.\n");
        return;
    }

    strcpy(sensors[num_sensors].name, name);
    sensors[num_sensors].temperature = 0;
    num_sensors++;
}

void remove_sensor(int index) {
    if (index < 0 || index >= num_sensors) {
        printf("Error: Invalid sensor index.\n");
        return;
    }

    num_sensors--;
    for (int i = index; i < num_sensors; i++) {
        sensors[i] = sensors[i+1];
    }
}

void update_sensor_temperature(int index, double temp) {
    if (index < 0 || index >= num_sensors) {
        printf("Error: Invalid sensor index.\n");
        return;
    }

    sensors[index].temperature = temp;
}

void print_sensor_info(int index) {
    if (index < 0 || index >= num_sensors) {
        printf("Error: Invalid sensor index.\n");
        return;
    }

    printf("Sensor name: %s\n", sensors[index].name);
    printf("Temperature: %.2f°C\n", sensors[index].temperature);
}

int main() {
    add_sensor("CPU");
    add_sensor("GPU");
    add_sensor("HDD");

    update_sensor_temperature(0, 60);
    update_sensor_temperature(1, 70);
    update_sensor_temperature(2, 40);

    print_sensor_info(0);
    print_sensor_info(1);
    print_sensor_info(2);

    remove_sensor(1);

    print_sensor_info(0);
    print_sensor_info(1);
    print_sensor_info(2);

    return 0;
}