//GPT-4o-mini DATASET v1.0 Category: Threading Library Implementation ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>

#define TOTAL_CUSTOMERS 5
#define DEPOSIT_AMOUNT 100
#define WITHDRAWAL_AMOUNT 50

pthread_mutex_t bank_mutex;
double bank_account_balance = 1000.0;

void* deposit(void* customer_id) {
    int id = *((int*)customer_id);
    for (int i = 0; i < 5; i++) {
        sleep(rand() % 3);  // Simulate time taken to decide to deposit
        pthread_mutex_lock(&bank_mutex); // Locking the bank account
        bank_account_balance += DEPOSIT_AMOUNT;
        printf("Customer %d deposited $%d. Current balance: $%.2f\n", id, DEPOSIT_AMOUNT, bank_account_balance);
        pthread_mutex_unlock(&bank_mutex); // Releasing the lock
    }
    return NULL;
}

void* withdraw(void* customer_id) {
    int id = *((int*)customer_id);
    for (int i = 0; i < 5; i++) {
        sleep(rand() % 3);  // Simulate time taken to decide to withdraw
        pthread_mutex_lock(&bank_mutex); // Locking the bank account
        if (bank_account_balance >= WITHDRAWAL_AMOUNT) {
            bank_account_balance -= WITHDRAWAL_AMOUNT;
            printf("Customer %d withdrew $%d. Current balance: $%.2f\n", id, WITHDRAWAL_AMOUNT, bank_account_balance);
        } else {
            printf("Customer %d attempted to withdraw $%d but insufficient funds. Current balance: $%.2f\n", id, WITHDRAWAL_AMOUNT, bank_account_balance);
        }
        pthread_mutex_unlock(&bank_mutex); // Releasing the lock
    }
    return NULL;
}

int main() {
    pthread_t customers[TOTAL_CUSTOMERS];
    int customer_ids[TOTAL_CUSTOMERS];

    // Initialize the mutex
    if (pthread_mutex_init(&bank_mutex, NULL) != 0) {
        printf("Mutex initialization failed\n");
        return 1;
    }
    
    // Seed the random number generator
    srand(time(NULL));

    // Create deposit and withdrawal threads
    for (int i = 0; i < TOTAL_CUSTOMERS; i++) {
        customer_ids[i] = i + 1;  // Assign customer IDs
        if (i % 2 == 0) {
            pthread_create(&customers[i], NULL, deposit, (void*)&customer_ids[i]);
        } else {
            pthread_create(&customers[i], NULL, withdraw, (void*)&customer_ids[i]);
        }
    }

    // Wait for all threads to finish
    for (int i = 0; i < TOTAL_CUSTOMERS; i++) {
        pthread_join(customers[i], NULL);
    }

    // Clean up the mutex
    pthread_mutex_destroy(&bank_mutex);

    printf("Final bank account balance: $%.2f\n", bank_account_balance);
    return 0;
}