//Falcon-180B DATASET v1.0 Category: Sentiment analysis tool ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <curl/curl.h>

#define MAX_URL_LENGTH 1000
#define MAX_TEXT_LENGTH 10000
#define API_KEY "YOUR_API_KEY_HERE"
#define API_URL "https://sentim-api.herokuapp.com/api/v1/text"

size_t WriteCallback(void* contents, size_t size, size_t nmemb, void* userp)
{
    size_t realsize = size * nmemb;
    char* data = (char*)malloc(realsize + 1);
    if (data == NULL)
        return 0;

    memcpy(data, contents, realsize);
    data[realsize] = '\0';

    *((char**)userp) = data;

    return realsize;
}

int main(int argc, char* argv[])
{
    if (argc!= 3)
    {
        printf("Usage: %s <text> <output>\n", argv[0]);
        return 1;
    }

    char* text = argv[1];
    char* output_file = argv[2];

    CURL* curl;
    CURLcode res;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if (curl)
    {
        struct curl_slist* headers = NULL;
        char url[MAX_URL_LENGTH];

        sprintf(url, "%s?text=%s&apikey=%s", API_URL, text, API_KEY);

        headers = curl_slist_append(headers, "Content-Type: application/json");

        curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, &output_file);
        curl_easy_setopt(curl, CURLOPT_HTTPHEADER, headers);

        res = curl_easy_perform(curl);

        if (res!= CURLE_OK)
            fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));

        curl_easy_cleanup(curl);
        curl_slist_free_all(headers);
    }

    curl_global_cleanup();

    return 0;
}