//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: peaceful
#include <stdio.h>

#define NUM_BYTES 4
#define NUM_BITS 8

// Function to print a byte in binary format
void print_byte_binary(char byte) {
    for (int i = 7; i >= 0; i--) {
        printf("%d", (byte >> i) & 1);
    }
}

// Function to print a byte in hexadecimal format
void print_byte_hex(char byte) {
    printf("0x%02X ", byte);
}

// Function to perform bitwise operations on two bytes
void bitwise_operations(char byte1, char byte2) {
    // Bitwise AND
    char result = byte1 & byte2;
    printf("Bitwise AND: ");
    print_byte_binary(result);
    printf("\n");

    // Bitwise OR
    result = byte1 | byte2;
    printf("Bitwise OR: ");
    print_byte_binary(result);
    printf("\n");

    // Bitwise XOR
    result = byte1 ^ byte2;
    printf("Bitwise XOR: ");
    print_byte_binary(result);
    printf("\n");

    // Bitwise NOT
    result = ~byte1;
    printf("Bitwise NOT: ");
    print_byte_binary(result);
    printf("\n");

    // Bitwise Left Shift
    result = byte1 << 2;
    printf("Bitwise Left Shift by 2: ");
    print_byte_binary(result);
    printf("\n");

    // Bitwise Right Shift
    result = byte1 >> 2;
    printf("Bitwise Right Shift by 2: ");
    print_byte_binary(result);
    printf("\n");
}

int main() {
    char byte1 = 0xAA;
    char byte2 = 0x55;

    // Print the bytes in binary and hexadecimal format
    printf("Byte 1: ");
    print_byte_binary(byte1);
    printf("\n");
    print_byte_hex(byte1);
    printf("\n");

    printf("Byte 2: ");
    print_byte_binary(byte2);
    printf("\n");
    print_byte_hex(byte2);
    printf("\n");

    // Perform bitwise operations on the bytes
    bitwise_operations(byte1, byte2);

    return 0;
}