//LLAMA2-13B DATASET v1.0 Category: Arithmetic ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_INT 2147483647
#define MIN_INT -2147483648

// Function to calculate the factorial of a given integer
int factorial(int n) {
    if (n == 0) {
        return 1;
    } else {
        return n * factorial(n - 1);
    }
}

// Function to calculate the fibonacci sequence of a given integer
int fibonacci(int n) {
    if (n == 0) {
        return 0;
    } else if (n == 1) {
        return 1;
    } else {
        return fibonacci(n - 1) + fibonacci(n - 2);
    }
}

// Function to calculate the greatest common divisor of two integers
int gcd(int a, int b) {
    if (a == 0) {
        return b;
    } else if (b == 0) {
        return a;
    } else {
        return gcd(b, a % b);
    }
}

int main() {
    int num1, num2, gcd_result;

    // Example 1: Calculate the factorial of 5
    printf("The factorial of 5 is: %d\n", factorial(5));

    // Example 2: Calculate the fibonacci sequence of 8
    printf("The fibonacci sequence of 8 is: %d\n", fibonacci(8));

    // Example 3: Calculate the greatest common divisor of 12 and 15
    printf("The greatest common divisor of 12 and 15 is: %d\n", gcd(12, 15));

    // Example 4: Calculate the sum of the factorials of the first 10 positive integers
    int sum = 0;
    for (int i = 1; i <= 10; i++) {
        sum += factorial(i);
    }
    printf("The sum of the factorials of the first 10 positive integers is: %d\n", sum);

    // Example 5: Calculate the product of the fibonacci sequence of the first 5 positive integers
    int product = 1;
    for (int i = 1; i <= 5; i++) {
        product *= fibonacci(i);
    }
    printf("The product of the fibonacci sequence of the first 5 positive integers is: %d\n", product);

    return 0;
}