//GEMINI-pro DATASET v1.0 Category: System administration ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <errno.h>

// Define the maximum number of child processes that can be created
#define MAX_CHILDREN 10

// Define the signal handler function
void sigchld_handler(int sig) {
    int status;
    pid_t pid;

    // Loop through all child processes and reap any that have exited
    while ((pid = waitpid(-1, &status, WNOHANG)) > 0) {
        if (WIFEXITED(status)) {
            printf("Child process %d exited with status %d\n", pid, WEXITSTATUS(status));
        } else if (WIFSIGNALED(status)) {
            printf("Child process %d was killed by signal %d\n", pid, WTERMSIG(status));
        } else if (WIFSTOPPED(status)) {
            printf("Child process %d was stopped by signal %d\n", pid, WSTOPSIG(status));
        }
    }
}

int main(int argc, char** argv) {
    // Register the signal handler function
    signal(SIGCHLD, sigchld_handler);

    // Create an array of child processes
    pid_t children[MAX_CHILDREN];

    // Create the child processes
    for (int i = 0; i < MAX_CHILDREN; i++) {
        children[i] = fork();
        if (children[i] == 0) {
            // This is the child process
            printf("Child process %d created with PID %d\n", i, getpid());

            // Sleep for a random amount of time
            sleep(rand() % 10 + 1);

            // Exit with a random status code
            exit(rand() % 256);
        } else if (children[i] < 0) {
            // Error creating the child process
            perror("fork");
            exit(EXIT_FAILURE);
        }
    }

    // Wait for all child processes to exit
    for (int i = 0; i < MAX_CHILDREN; i++) {
        waitpid(children[i], NULL, 0);
    }

    return EXIT_SUCCESS;
}