//Gemma-7B DATASET v1.0 Category: Simple Web Server ; Style: Romeo and Juliet
#include <stdio.h>
#include <netdb.h>
#include <stdlib.h>

#define MAX_CLIENTS 10

int main()
{
    int sockfd, newsockfd, client_addr_len, i;
    struct sockaddr_in client_addr;
    char buffer[1024];

    sockfd = socket(AF_INET, SOCK_STREAM, htons(8080));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    listen(sockfd, MAX_CLIENTS);

    for (i = 0; i < MAX_CLIENTS; i++)
    {
        newsockfd = accept(sockfd, (struct sockaddr *)&client_addr, &client_addr_len);
        if (newsockfd < 0)
        {
            perror("Error accepting client");
            continue;
        }

        printf("Client connected: %s:%d\n", client_addr.sin_addr.s_addr, client_addr.sin_port);

        // Send a welcome message to the client
        send(newsockfd, "Welcome to the server!", 19, 0);

        // Receive a message from the client
        recv(newsockfd, buffer, 1024, 0);

        // Print the client's message
        printf("Client message: %s\n", buffer);

        // Send a response to the client
        send(newsockfd, "Server received your message!", 24, 0);

        // Close the client connection
        close(newsockfd);
    }

    close(sockfd);

    return 0;
}