//GPT-4o-mini DATASET v1.0 Category: Natural Language Date Converter ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_DATE_LEN 11
#define MONTHS_IN_YEAR 12

const char *months[MONTHS_IN_YEAR] = {
    "January", "February", "March", "April", "May", "June",
    "July", "August", "September", "October", "November", "December"
};

// Function to validate and parse the date string
int parse_date(const char *date_str, int *day, int *month, int *year) {
    char tmp[3]; // Temporary string for day and month
    // Check if the string format is correct
    if (strlen(date_str) != MAX_DATE_LEN || date_str[2] != '/' || date_str[5] != '/') {
        return 0;
    }
    
    // Copy day, month, and year parts
    strncpy(tmp, date_str, 2);
    tmp[2] = '\0';
    *day = atoi(tmp);
    
    strncpy(tmp, date_str + 3, 2);
    tmp[2] = '\0';
    *month = atoi(tmp);
    
    strncpy(tmp, date_str + 6, 4);
    tmp[4] = '\0';
    *year = atoi(tmp);
    
    // Validate ranges
    if (*month < 1 || *month > MONTHS_IN_YEAR || *day < 1 || *day > 31 || *year < 0)
        return 0;

    // Check for days in month (simple validation)
    if ((*month == 2 && *day > 29) || 
        ((*month == 4 || *month == 6 || *month == 9 || *month == 11) && *day > 30)) {
        return 0;
    }

    // Leap year check (for February)
    if (*month == 2 && *day == 29) {
        if (!((*year % 4 == 0 && *year % 100 != 0) || (*year % 400 == 0)))
            return 0;
    }

    return 1; // Successfully parsed
}

// Function to convert date
void convert_date(int day, int month, int year, char *output_str) {
    sprintf(output_str, "%s %02d, %d", months[month - 1], day, year);
}

int main() {
    char input_date[MAX_DATE_LEN];
    int day, month, year;
    char output_date[50];

    printf("Enter a date in format (dd/mm/yyyy): ");
    fgets(input_date, sizeof(input_date), stdin);

    // Remove newline character if present
    input_date[strcspn(input_date, "\n")] = '\0';

    if (parse_date(input_date, &day, &month, &year)) {
        convert_date(day, month, year, output_date);
        printf("Converted date: %s\n", output_date);
    } else {
        printf("Invalid date format or values. Please enter a valid date.\n");
    }

    return 0;
}