//Falcon-180B DATASET v1.0 Category: Poker Game ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_CARDS 52
#define NUM_PLAYERS 2

enum card_suit { HEARTS, DIAMONDS, CLUBS, SPADES };
enum card_rank { TWO, THREE, FOUR, FIVE, SIX, SEVEN, EIGHT, NINE, TEN, JACK, QUEEN, KING, ACE };

struct card {
    enum card_suit suit;
    enum card_rank rank;
};

void shuffle_deck(struct card deck[]);
void deal_card(struct card deck[], int *top_card, struct card *card);
int compare_cards(struct card card1, struct card card2);
void sort_hand(struct card hand[], int num_cards);

int main() {
    struct card deck[NUM_CARDS];
    int top_card = 0;
    int num_cards_dealt = 0;

    // Initialize deck of cards
    for (int i = 0; i < NUM_CARDS; i++) {
        deck[i].suit = (enum card_suit)i % 4;
        deck[i].rank = (enum card_rank)(i / 4) + 1;
    }

    // Shuffle deck
    shuffle_deck(deck);

    // Deal cards to players
    for (int i = 0; i < NUM_PLAYERS; i++) {
        for (int j = 0; j < 5; j++) {
            deal_card(deck, &top_card, &deck[num_cards_dealt]);
            num_cards_dealt++;
        }
    }

    // Sort hands by rank
    for (int i = 0; i < NUM_PLAYERS; i++) {
        sort_hand(deck + i * 5, 5);
    }

    // Determine winner
    int winner = 0;
    for (int i = 1; i < NUM_PLAYERS; i++) {
        if (compare_cards(deck[i * 5], deck[winner * 5]) > 0) {
            winner = i;
        }
    }

    printf("Player %d wins!\n", winner + 1);

    return 0;
}

void shuffle_deck(struct card deck[]) {
    srand(time(NULL));
    for (int i = 0; i < NUM_CARDS; i++) {
        int rand_index = rand() % NUM_CARDS;
        struct card temp = deck[i];
        deck[i] = deck[rand_index];
        deck[rand_index] = temp;
    }
}

void deal_card(struct card deck[], int *top_card, struct card *card) {
    if (*top_card >= NUM_CARDS) {
        *top_card = 0;
        shuffle_deck(deck);
    }
    *card = deck[*top_card];
    (*top_card)++;
}

int compare_cards(struct card card1, struct card card2) {
    if (card1.rank > card2.rank) {
        return 1;
    } else if (card1.rank < card2.rank) {
        return -1;
    } else {
        return 0;
    }
}

void sort_hand(struct card hand[], int num_cards) {
    for (int i = 0; i < num_cards - 1; i++) {
        for (int j = i + 1; j < num_cards; j++) {
            if (compare_cards(hand[i], hand[j]) > 0) {
                struct card temp = hand[i];
                hand[i] = hand[j];
                hand[j] = temp;
            }
        }
    }
}