//Falcon-180B DATASET v1.0 Category: Task Scheduler ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <time.h>
#include <string.h>

#define MAX_COMMANDS 100
#define MAX_COMMAND_LENGTH 1024

typedef struct {
    char command[MAX_COMMAND_LENGTH];
    time_t time;
} task;

void add_task(task *tasks, int num_tasks, char *command) {
    if (num_tasks >= MAX_COMMANDS) {
        printf("Error: Too many tasks.\n");
        return;
    }
    strcpy(tasks[num_tasks].command, command);
    time(&tasks[num_tasks].time);
    num_tasks++;
}

void print_tasks(task *tasks, int num_tasks) {
    printf("Tasks:\n");
    for (int i = 0; i < num_tasks; i++) {
        printf("%s - %s\n", ctime(&tasks[i].time), tasks[i].command);
    }
}

void schedule_tasks(task *tasks, int num_tasks) {
    for (int i = 0; i < num_tasks; i++) {
        if (tasks[i].time <= time(NULL)) {
            system(tasks[i].command);
            printf("%s executed.\n", tasks[i].command);
        }
    }
}

int main() {
    task tasks[MAX_COMMANDS];
    int num_tasks = 0;

    add_task(tasks, num_tasks, "ls -l");
    add_task(tasks, num_tasks, "sleep 5");
    add_task(tasks, num_tasks, "echo Hello, world!");

    print_tasks(tasks, num_tasks);

    schedule_tasks(tasks, num_tasks);

    return 0;
}