//GPT-4o-mini DATASET v1.0 Category: Traffic Flow Simulation ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#define ROAD_LENGTH 40
#define NUM_CARS 5

typedef enum { RED, GREEN } TrafficLight;

typedef struct {
    int position;
    int speed; // 1 for slow, 2 for fast
} Car;

void initializeCars(Car cars[]) {
    for (int i = 0; i < NUM_CARS; i++) {
        cars[i].position = rand() % (ROAD_LENGTH - 1);
        cars[i].speed = (rand() % 2) + 1; // Random speed between 1 and 2
    }
}

void toggleTrafficLight(TrafficLight *light) {
    *light = (*light == RED) ? GREEN : RED;
}

void printRoad(Car cars[], TrafficLight light) {
    system("clear"); // Clear the terminal (works in Linux)
    char road[ROAD_LENGTH + 1];
    for (int i = 0; i < ROAD_LENGTH; i++) {
        road[i] = ' ';
    }
    road[ROAD_LENGTH] = '\0';

    for (int i = 0; i < NUM_CARS; i++) {
        if (cars[i].position < ROAD_LENGTH) {
            road[cars[i].position] = 'C'; // Represent car with 'C'
        }
    }

    printf("Traffic Light: %s\n", light == RED ? "RED" : "GREEN");
    printf("Road: %s\n", road);
    printf("\n");
}

void updateCarPositions(Car cars[], TrafficLight light) {
    for (int i = 0; i < NUM_CARS; i++) {
        if (light == GREEN) {
            cars[i].position += cars[i].speed;
        }

        if (cars[i].position >= ROAD_LENGTH) {
            cars[i].position = ROAD_LENGTH - 1; // Stop at the end of the road
        }
    }
}

int main() {
    srand(time(NULL));
    Car cars[NUM_CARS];
    TrafficLight light = RED;
    int cycles = 10;

    initializeCars(cars);

    for (int cycle = 0; cycle < cycles; cycle++) {
        printRoad(cars, light);
        updateCarPositions(cars, light);
        sleep(1); // Wait for 1 second
        toggleTrafficLight(&light);
    }

    printf("Simulation ended. Thank you for watching!\n");
    return 0;
}