//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define DAYS 10
#define WEATHER_TYPES 3

// Function prototypes
void generate_weather(int weather[DAYS]);
void display_weather(int weather[DAYS]);
const char* weather_to_string(int weather_type);

int main() {
    int weather[DAYS];

    // Seed the random number generator
    srand(time(NULL));

    // Generate random weather data
    generate_weather(weather);

    // Display the weather data
    display_weather(weather);

    return 0;
}

// Generate random weather types for each day
void generate_weather(int weather[DAYS]) {
    for (int i = 0; i < DAYS; i++) {
        // Randomly assign a weather type: 0 = Sunny, 1 = Rainy, 2 = Cloudy
        weather[i] = rand() % WEATHER_TYPES;
    }
}

// Convert weather type to a string for easier reading
const char* weather_to_string(int weather_type) {
    switch (weather_type) {
        case 0: return "Sunny";
        case 1: return "Rainy";
        case 2: return "Cloudy";
        default: return "Unknown";
    }
}

// Display the weather for each day
void display_weather(int weather[DAYS]) {
    printf("Weather Simulation for the Next %d Days:\n", DAYS);
    printf("---------------------------------------------\n");

    for (int i = 0; i < DAYS; i++) {
        printf("Day %2d: %s\n", i + 1, weather_to_string(weather[i]));
    }
}