//MISTRAL-7B DATASET v1.0 Category: Banking Record System ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
    int account_number;
    char name[50];
    float balance;
} BankRecord;

#define MAX_RECORDS 1000

BankRecord records[MAX_RECORDS];
int num_records = 0;

void create_record(int acc_num, const char *name, float initial_balance) {
    if (num_records >= MAX_RECORDS) {
        printf("Error: Maximum number of records reached.\n");
        return;
    }

    records[num_records].account_number = acc_num;
    strcpy(records[num_records].name, name);
    records[num_records].balance = initial_balance;

    num_records++;
}

void deposit(int acc_num, float amount) {
    for (int i = 0; i < num_records; i++) {
        if (records[i].account_number == acc_num) {
            records[i].balance += amount;
            return;
        }
    }

    printf("Error: Account not found.\n");
}

void withdraw(int acc_num, float amount) {
    for (int i = 0; i < num_records; i++) {
        if (records[i].account_number == acc_num) {
            if (records[i].balance >= amount) {
                records[i].balance -= amount;
            } else {
                printf("Error: Insufficient balance.\n");
            }
            return;
        }
    }

    printf("Error: Account not found.\n");
}

void print_record(int acc_num) {
    for (int i = 0; i < num_records; i++) {
        if (records[i].account_number == acc_num) {
            printf("Account Number: %d\n", records[i].account_number);
            printf("Name: %s\n", records[i].name);
            printf("Balance: %.2f\n", records[i].balance);
            return;
        }
    }

    printf("Error: Account not found.\n");
}

int main() {
    create_record(12345, "John Doe", 1000.0);
    create_record(23456, "Jane Doe", 2000.0);

    deposit(12345, 500.0);
    withdraw(12345, 200.0);
    print_record(12345);

    deposit(23456, 1500.0);
    withdraw(23456, 700.0);
    print_record(23456);

    return 0;
}