//Falcon-180B DATASET v1.0 Category: Mailing list manager ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LENGTH 50
#define MAX_EMAIL_LENGTH 100
#define MAX_SUBJECT_LENGTH 100
#define MAX_MESSAGE_LENGTH 1000

typedef struct {
    char name[MAX_NAME_LENGTH];
    char email[MAX_EMAIL_LENGTH];
} contact;

typedef struct {
    char subject[MAX_SUBJECT_LENGTH];
    char message[MAX_MESSAGE_LENGTH];
} email;

void add_contact(contact *list, int size, char *name, char *email) {
    int i;
    for (i = 0; i < size; i++) {
        if (strcmp(list[i].email, email) == 0) {
            strcpy(list[i].name, name);
            return;
        }
    }
    strcpy(list[size].name, name);
    strcpy(list[size].email, email);
    size++;
}

void remove_contact(contact *list, int size, char *email) {
    int i;
    for (i = 0; i < size; i++) {
        if (strcmp(list[i].email, email) == 0) {
            memmove(&list[i], &list[i+1], (size - i - 1) * sizeof(contact));
            size--;
            return;
        }
    }
}

void send_email(contact *list, int size, char *subject, char *message) {
    int i;
    for (i = 0; i < size; i++) {
        email e;
        strcpy(e.subject, subject);
        strcpy(e.message, message);
        printf("Sending email to %s (%s)\n", list[i].name, list[i].email);
    }
}

int main() {
    contact list[10];
    int size = 0;

    add_contact(list, size, "John Doe", "john@example.com");
    add_contact(list, size, "Jane Smith", "jane@example.com");

    send_email(list, size, "Hello!", "This is a test email.");

    remove_contact(list, size, "john@example.com");

    send_email(list, size, "Goodbye!", "John Doe has been removed from the mailing list.");

    return 0;
}