//Falcon-180B DATASET v1.0 Category: Graph Coloring Problem ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>

#define MAX_NODES 10000
#define MAX_EDGES 100000
#define MAX_COLOR 7

typedef struct {
    int node1;
    int node2;
    int weight;
} Edge;

typedef struct {
    int node;
    int color;
} Node;

Edge edges[MAX_EDGES];
Node nodes[MAX_NODES];
int numEdges = 0;
int numNodes = 0;
int *colors = NULL;

void addEdge(int node1, int node2, int weight) {
    edges[numEdges] = (Edge) {node1, node2, weight};
    numEdges++;
}

void addNode(int node) {
    nodes[numNodes] = (Node) {node, -1};
    numNodes++;
}

bool isValid(int node, int color) {
    for (int i = 0; i < numEdges; i++) {
        Edge e = edges[i];
        if (nodes[e.node1].color == color || nodes[e.node2].color == color) {
            return false;
        }
    }
    return true;
}

bool colorGraph() {
    colors = malloc(MAX_COLOR * sizeof(int));
    if (colors == NULL) {
        printf("Error: Memory allocation failed\n");
        exit(1);
    }
    for (int i = 0; i < numNodes; i++) {
        nodes[i].color = -1;
    }
    for (int i = 0; i < numNodes; i++) {
        if (nodes[i].color == -1) {
            for (int j = 0; j < MAX_COLOR; j++) {
                if (isValid(i, j)) {
                    nodes[i].color = j;
                    break;
                }
            }
            if (nodes[i].color == -1) {
                printf("Error: Graph is not %d-colorable\n", MAX_COLOR);
                exit(1);
            }
        }
    }
    return true;
}

int main() {
    addNode(0);
    addNode(1);
    addEdge(0, 1, 1);
    addNode(2);
    addEdge(0, 2, 1);
    addEdge(1, 2, 1);
    colorGraph();
    printf("Node 0 color: %d\n", nodes[0].color);
    printf("Node 1 color: %d\n", nodes[1].color);
    printf("Node 2 color: %d\n", nodes[2].color);
    free(colors);
    return 0;
}