//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

typedef struct {
    char name[50];
    int votes;
} candidate;

typedef struct {
    char name[50];
    int voted;
} voter;

candidate candidates[MAX_CANDIDATES];
voter voters[MAX_VOTERS];

int num_candidates = 0;
int num_voters = 0;

void add_candidate(char *name) {
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_voter(char *name) {
    strcpy(voters[num_voters].name, name);
    voters[num_voters].voted = 0;
    num_voters++;
}

void vote(char *voter_name, char *candidate_name) {
    int i, j;

    for (i = 0; i < num_voters; i++) {
        if (strcmp(voters[i].name, voter_name) == 0) {
            if (voters[i].voted == 1) {
                printf("Error: Voter %s has already voted.\n", voter_name);
                return;
            }
            voters[i].voted = 1;
            break;
        }
    }

    if (i == num_voters) {
        printf("Error: Voter %s not found.\n", voter_name);
        return;
    }

    for (j = 0; j < num_candidates; j++) {
        if (strcmp(candidates[j].name, candidate_name) == 0) {
            candidates[j].votes++;
            break;
        }
    }

    if (j == num_candidates) {
        printf("Error: Candidate %s not found.\n", candidate_name);
    }
}

void print_results() {
    int i;

    printf("Election Results:\n");
    for (i = 0; i < num_candidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    int i;

    add_candidate("John Smith");
    add_candidate("Jane Doe");
    add_candidate("Bill Jones");

    add_voter("Alice");
    add_voter("Bob");
    add_voter("Carol");

    vote("Alice", "John Smith");
    vote("Bob", "Jane Doe");
    vote("Carol", "Bill Jones");

    print_results();

    return 0;
}