//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#define WIDTH 32
#define HEIGHT 32

typedef struct {
    uint8_t r, g, b;
} Color;

typedef struct {
    Color pixels[HEIGHT][WIDTH];
} Canvas;

void initializeCanvas(Canvas *canvas) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            canvas->pixels[y][x] = (Color){255, 255, 255}; // White background
        }
    }
}

void setPixel(Canvas *canvas, int x, int y, Color color) {
    if (x >= 0 && x < WIDTH && y >= 0 && y < HEIGHT) {
        canvas->pixels[y][x] = color;
    }
}

void drawRectangle(Canvas *canvas, int x, int y, int width, int height, Color color) {
    for (int j = 0; j < height; j++) {
        for (int i = 0; i < width; i++) {
            setPixel(canvas, x + i, y + j, color);
        }
    }
}

void drawCircle(Canvas *canvas, int xc, int yc, int radius, Color color) {
    for (int y = -radius; y <= radius; y++) {
        for (int x = -radius; x <= radius; x++) {
            if (x*x + y*y <= radius*radius) {
                setPixel(canvas, xc + x, yc + y, color);
            }
        }
    }
}

void saveCanvasToPPM(Canvas *canvas, const char *filename) {
    FILE *file = fopen(filename, "wb");
    if (!file) {
        fprintf(stderr, "Cannot open file for writing: %s\n", filename);
        exit(1);
    }
    fprintf(file, "P6\n%d %d\n255\n", WIDTH, HEIGHT);
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            fwrite(&canvas->pixels[y][x], sizeof(Color), 1, file);
        }
    }
    fclose(file);
}

void drawArt(Canvas *canvas) {
    Color blue = {0, 0, 255};
    Color red = {255, 0, 0};
    Color green = {0, 255, 0};
    Color yellow = {255, 255, 0};
    
    // Draw a blue rectangle
    drawRectangle(canvas, 5, 5, 10, 15, blue);
    
    // Draw a red circle
    drawCircle(canvas, 20, 10, 5, red);
    
    // Draw a green rectangle
    drawRectangle(canvas, 25, 20, 6, 6, green);
    
    // Draw a yellow square
    drawRectangle(canvas, 5, 18, 6, 6, yellow);
}

int main() {
    Canvas canvas;
    initializeCanvas(&canvas);
    
    drawArt(&canvas);
    
    saveCanvasToPPM(&canvas, "pixel_art.ppm");
    
    printf("Pixel art saved to pixel_art.ppm\n");
    return 0;
}