//LLAMA2-13B DATASET v1.0 Category: Data mining ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_STR_LEN 1024
#define MIN_SUPRISE 0.5
#define MAX_SUPRISE 1.0

// Structure to store the data
struct data {
    char *word;
    int frequency;
};

// Function to generate a surprise value
float surprise(struct data *data, int num_data) {
    int i, j;
    float sum_frequency = 0;
    float total_frequency = 0;

    // Calculate the sum of frequencies
    for (i = 0; i < num_data; i++) {
        sum_frequency += data[i].frequency;
    }

    // Calculate the total frequency
    for (i = 0; i < num_data; i++) {
        total_frequency += data[i].frequency;
    }

    // Calculate the surprise value
    for (j = 0; j < num_data; j++) {
        float surprise_value = (data[j].frequency / total_frequency) - (sum_frequency / total_frequency);
        if (surprise_value > MIN_SUPRISE && surprise_value < MAX_SUPRISE) {
            return surprise_value;
        }
    }

    // If no surprise value is found, return the maximum value
    return MAX_SUPRISE;
}

int main() {
    srand(time(NULL));

    // Generate some random data
    struct data data[10] = {
        {"the", 5},
        {"is", 3},
        {"a", 4},
        {"surprised", 2},
        {"program", 1},
        {"in", 2},
        {"c", 1},
        {"style", 1},
        {"surprise", 1}
    };

    // Calculate the surprise value
    int num_data = sizeof(data) / sizeof(data[0]);
    float surprise_value = surprise(data, num_data);

    // Print the surprise value
    printf("Surprise value: %f\n", surprise_value);

    return 0;
}