//GEMINI-pro DATASET v1.0 Category: Appointment Scheduler ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define MAX_APPOINTMENTS 100
#define MAX_NAME_LENGTH 50

typedef struct Appointment {
    char name[MAX_NAME_LENGTH];
    int start_time;
    int end_time;
} Appointment;

Appointment appointments[MAX_APPOINTMENTS];
int num_appointments = 0;

void print_appointment(Appointment *appointment) {
    printf("%s: %02d:%02d - %02d:%02d\n", appointment->name, appointment->start_time / 60, appointment->start_time % 60, appointment->end_time / 60, appointment->end_time % 60);
}

bool is_overlapping(Appointment *appointment1, Appointment *appointment2) {
    return (appointment1->start_time <= appointment2->end_time) && (appointment2->start_time <= appointment1->end_time);
}

bool add_appointment(Appointment appointment) {
    if (num_appointments >= MAX_APPOINTMENTS) {
        return false;
    }

    for (int i = 0; i < num_appointments; i++) {
        if (is_overlapping(&appointment, &appointments[i])) {
            return false;
        }
    }

    appointments[num_appointments++] = appointment;
    return true;
}

void print_all_appointments() {
    for (int i = 0; i < num_appointments; i++) {
        print_appointment(&appointments[i]);
    }
}

int main() {
    // Create some sample appointments
    Appointment appointment1 = {"John Smith", 900, 1000};
    Appointment appointment2 = {"Jane Doe", 1030, 1130};
    Appointment appointment3 = {"Bill Jones", 1200, 1300};

    // Add the appointments to the scheduler
    add_appointment(appointment1);
    add_appointment(appointment2);
    add_appointment(appointment3);

    // Print all the appointments
    print_all_appointments();

    return 0;
}