//GEMINI-pro DATASET v1.0 Category: Packet Capturer with pcap library ; Style: intelligent
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>

// Define the packet capture callback function
void handle_packet(u_char *user, const struct pcap_pkthdr *header,
                   const u_char *packet) {
  // Print the packet timestamp
  printf("Packet timestamp: %ld\n", header->ts.tv_sec);

  // Print the source and destination IP addresses
  struct in_addr src_addr, dst_addr;
  memcpy(&src_addr, packet + 12, sizeof(src_addr));
  memcpy(&dst_addr, packet + 16, sizeof(dst_addr));
  printf("Source IP: %s\n", inet_ntoa(src_addr));
  printf("Destination IP: %s\n", inet_ntoa(dst_addr));

  // Print the packet length
  printf("Packet length: %d\n", header->len);

  // Print the packet data
  printf("Packet data: ");
  for (int i = 0; i < header->len; i++) {
    printf("%02x ", packet[i]);
  }
  printf("\n\n");
}

int main() {
  // Open the network interface for packet capture
  char *interface = "eth0";
  pcap_t *handle = pcap_open_live(interface, BUFSIZ, 1, 1000, NULL);
  if (handle == NULL) {
    fprintf(stderr, "Error opening network interface: %s\n", pcap_geterr(handle));
    return EXIT_FAILURE;
  }

  // Set the packet capture filter
  char *filter = "tcp and port 80";
  if (pcap_compile(handle, &filter, 1, 0, NULL) == -1) {
    fprintf(stderr, "Error compiling filter: %s\n", pcap_geterr(handle));
    return EXIT_FAILURE;
  }
  if (pcap_setfilter(handle, &filter) == -1) {
    fprintf(stderr, "Error setting filter: %s\n", pcap_geterr(handle));
    return EXIT_FAILURE;
  }

  // Start the packet capture loop
  pcap_loop(handle, -1, &handle_packet, NULL);

  // Close the network interface and free resources
  pcap_close(handle);

  return EXIT_SUCCESS;
}