//Falcon-180B DATASET v1.0 Category: Medical Store Management System ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_NAME_LEN 50
#define MAX_QUANTITY 1000

typedef struct {
    char name[MAX_NAME_LEN];
    int quantity;
    float price;
} Item;

void addItem(Item* items, int numItems, char* name, int quantity, float price) {
    if (numItems >= MAX_ITEMS) {
        printf("Error: Maximum number of items reached.\n");
        return;
    }

    strcpy(items[numItems].name, name);
    items[numItems].quantity = quantity;
    items[numItems].price = price;

    numItems++;
}

void removeItem(Item* items, int numItems, char* name) {
    int i;

    for (i = 0; i < numItems; i++) {
        if (strcmp(items[i].name, name) == 0) {
            items[i].quantity = 0;
            printf("Item '%s' removed.\n", name);
            break;
        }
    }
}

void updateItemQuantity(Item* items, int numItems, char* name, int quantity) {
    int i;

    for (i = 0; i < numItems; i++) {
        if (strcmp(items[i].name, name) == 0) {
            items[i].quantity += quantity;
            printf("Item '%s' quantity updated.\n", name);
            break;
        }
    }
}

void displayItems(Item* items, int numItems) {
    int i;

    for (i = 0; i < numItems; i++) {
        if (items[i].quantity > 0) {
            printf("Item Name: %s\n", items[i].name);
            printf("Item Quantity: %d\n", items[i].quantity);
            printf("Item Price: $%.2f\n\n", items[i].price);
        }
    }
}

int main() {
    Item items[MAX_ITEMS];
    int numItems = 0;

    addItem(items, numItems, "Aspirin", 100, 0.50);
    addItem(items, numItems, "Tylenol", 50, 1.00);
    addItem(items, numItems, "Advil", 75, 0.75);

    displayItems(items, numItems);

    removeItem(items, numItems, "Aspirin");
    updateItemQuantity(items, numItems, "Tylenol", 25);

    displayItems(items, numItems);

    return 0;
}