//Falcon-180B DATASET v1.0 Category: Port Scanner ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <errno.h>

#define MAX_THREADS 64
#define BUFFER_SIZE 1024

int target_port;
char target_ip[20];
int num_threads;

void *scan_port(void *arg) {
    int sockfd, port;
    struct sockaddr_in serv_addr;
    char buffer[BUFFER_SIZE];

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        printf("Error opening socket\n");
        exit(1);
    }

    memset(&serv_addr, 0, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    inet_pton(AF_INET, target_ip, &serv_addr.sin_addr);
    port = htons(target_port);

    if (connect(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) == -1) {
        printf("Port %d is closed\n", target_port);
        close(sockfd);
        return NULL;
    }

    printf("Port %d is open\n", target_port);
    close(sockfd);
    return NULL;
}

int main(int argc, char **argv) {
    int opt;
    int i;

    while ((opt = getopt(argc, argv, "t:n:"))!= -1) {
        switch (opt) {
            case 't':
                strcpy(target_ip, optarg);
                break;
            case 'n':
                num_threads = atoi(optarg);
                break;
            default:
                printf("Usage: %s -t <target_ip> -n <num_threads>\n", argv[0]);
                exit(1);
        }
    }

    target_port = 1;

    pthread_t threads[MAX_THREADS];

    for (i = 0; i < num_threads; i++) {
        pthread_create(&threads[i], NULL, scan_port, NULL);
    }

    for (i = 0; i < num_threads; i++) {
        pthread_join(threads[i], NULL);
    }

    return 0;
}