//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define MAX_DAYS 7
#define TEMP_MIN -30
#define TEMP_MAX 40
#define HUMIDITY_MIN 0
#define HUMIDITY_MAX 100
#define WIND_MIN 0
#define WIND_MAX 20

typedef struct {
    int day;
    double temperature;
    int humidity;
    double windSpeed;
    char condition[20];
} WeatherData;

WeatherData generateWeatherData(int day) {
    WeatherData data;
    data.day = day;
    data.temperature = (rand() % (TEMP_MAX - TEMP_MIN + 1)) + TEMP_MIN;
    data.humidity = rand() % (HUMIDITY_MAX - HUMIDITY_MIN + 1);
    data.windSpeed = (rand() % (WIND_MAX - WIND_MIN + 1)) + WIND_MIN;

    // Assign weather condition based on random temperature
    if (data.temperature < 0) {
        strcpy(data.condition, "Snow");
    } else if (data.temperature < 15) {
        strcpy(data.condition, "Rain");
    } else if (data.temperature < 30) {
        strcpy(data.condition, "Cloudy");
    } else {
        strcpy(data.condition, "Sunny");
    }

    return data;
}

void printWeatherForecast(WeatherData forecast[], int days) {
    printf("Weather Forecast for the Next %d Days:\n", days);
    printf("-------------------------------------------------\n");
    printf("Day    Temperature (°C)    Humidity (%)    Wind Speed (km/h)    Condition\n");
    printf("-------------------------------------------------\n");

    for (int i = 0; i < days; i++) {
        printf("%-6d %-20.2f %-18d %-20.2f %-10s\n",
               forecast[i].day,
               forecast[i].temperature,
               forecast[i].humidity,
               forecast[i].windSpeed,
               forecast[i].condition);
    }
    printf("-------------------------------------------------\n");
}

int main() {
    srand(time(NULL));
    WeatherData forecast[MAX_DAYS];

    for (int i = 0; i < MAX_DAYS; i++) {
        forecast[i] = generateWeatherData(i + 1);
    }

    printWeatherForecast(forecast, MAX_DAYS);

    double avgTemp = 0, avgHumidity = 0, avgWindSpeed = 0;

    for (int i = 0; i < MAX_DAYS; i++) {
        avgTemp += forecast[i].temperature;
        avgHumidity += forecast[i].humidity;
        avgWindSpeed += forecast[i].windSpeed;
    }

    avgTemp /= MAX_DAYS;
    avgHumidity /= MAX_DAYS;
    avgWindSpeed /= MAX_DAYS;

    printf("Average Temperature: %.2f °C\n", avgTemp);
    printf("Average Humidity: %.2f %%\n", avgHumidity);
    printf("Average Wind Speed: %.2f km/h\n", avgWindSpeed);

    return 0;
}