//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

void displayError(const char *errMsg) {
    fprintf(stderr, "Oops! An error occurred: %s\n", errMsg);
}

int callback(void *data, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s: %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

void createTable(sqlite3 *db) {
    char *errMsg;
    const char *sql = "CREATE TABLE IF NOT EXISTS WIZARD("
                      "ID INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, "
                      "NAME TEXT NOT NULL, "
                      "SPELL TEXT NOT NULL);";

    int rc = sqlite3_exec(db, sql, 0, 0, &errMsg);
    if (rc != SQLITE_OK) {
        displayError(errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Holla! The magical table WIZARD has been created!\n");
    }
}

void insertWizards(sqlite3 *db) {
    const char *sql[3] = {
        "INSERT INTO WIZARD (NAME, SPELL) VALUES ('Merlin', 'Transmutation');",
        "INSERT INTO WIZARD (NAME, SPELL) VALUES ('Gandalf', 'Fireball');",
        "INSERT INTO WIZARD (NAME, SPELL) VALUES ('Dumbledore', 'Invisibility');"
    };

    for (int i = 0; i < 3; ++i) {
        char *errMsg;
        int rc = sqlite3_exec(db, sql[i], 0, 0, &errMsg);
        if (rc != SQLITE_OK) {
            displayError(errMsg);
            sqlite3_free(errMsg);
        } else {
            printf("A new wizard has entered the realm: %s\n", sql[i]);
        }
    }
}

void queryWizards(sqlite3 *db) {
    const char *sql = "SELECT * FROM WIZARD;";
    char *errMsg;
    printf("Summoning the wizards...\n");

    int rc = sqlite3_exec(db, sql, callback, 0, &errMsg);
    if (rc != SQLITE_OK) {
        displayError(errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("The wizardly secrets have been revealed!\n");
    }
}

int main() {
    sqlite3 *db;
    int exit = sqlite3_open("wizard.db", &db);
    if (exit != SQLITE_OK) {
        fprintf(stderr, "Failed to open the database! Error: %s\n", sqlite3_errmsg(db));
        return EXIT_FAILURE;
    }

    printf("Welcome, noble sorcerer! Let us embark on a journey to create a mystical database...\n");

    createTable(db);
    insertWizards(db);
    queryWizards(db);

    printf("Farewell, magician! May your spells be ever effective!\n");

    sqlite3_close(db);
    return EXIT_SUCCESS;
}