//GEMINI-pro DATASET v1.0 Category: Educational ; Style: scalable
#include <stdlib.h>
#include <stdio.h>

typedef struct node {
    int data;
    struct node *next;
} node_t;

typedef struct list {
    node_t *head;
    node_t *tail;
    int size;
} list_t;

list_t *create_list(void) {
    list_t *list = malloc(sizeof(list_t));
    if (list == NULL) {
        fprintf(stderr, "Error: malloc failed\n");
        return NULL;
    }
    list->head = NULL;
    list->tail = NULL;
    list->size = 0;
    return list;
}

void destroy_list(list_t *list) {
    node_t *current = list->head;
    while (current != NULL) {
        node_t *next = current->next;
        free(current);
        current = next;
    }
    free(list);
}

int add_to_list(list_t *list, int data) {
    node_t *new_node = malloc(sizeof(node_t));
    if (new_node == NULL) {
        fprintf(stderr, "Error: malloc failed\n");
        return -1;
    }
    new_node->data = data;
    new_node->next = NULL;
    if (list->size == 0) {
        list->head = new_node;
        list->tail = new_node;
    } else {
        list->tail->next = new_node;
        list->tail = new_node;
    }
    list->size++;
    return 0;
}

int remove_from_list(list_t *list, int data) {
    node_t *current = list->head;
    node_t *previous = NULL;
    while (current != NULL) {
        if (current->data == data) {
            if (previous == NULL) {
                list->head = current->next;
            } else {
                previous->next = current->next;
            }
            if (current == list->tail) {
                list->tail = previous;
            }
            free(current);
            list->size--;
            return 0;
        }
        previous = current;
        current = current->next;
    }
    return -1;
}

int print_list(list_t *list) {
    node_t *current = list->head;
    while (current != NULL) {
        printf("%d ", current->data);
        current = current->next;
    }
    printf("\n");
    return 0;
}

int main(void) {
    list_t *list = create_list();
    if (list == NULL) {
        return EXIT_FAILURE;
    }
    add_to_list(list, 1);
    add_to_list(list, 2);
    add_to_list(list, 3);
    add_to_list(list, 4);
    add_to_list(list, 5);
    print_list(list);
    remove_from_list(list, 3);
    print_list(list);
    destroy_list(list);
    return EXIT_SUCCESS;
}