//GEMINI-pro DATASET v1.0 Category: Socket programming ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>

// Define the port number
#define PORT 8080

// Define the maximum number of clients
#define MAX_CLIENTS 10

// Define the maximum length of a message
#define MAX_MESSAGE_LENGTH 1024

// Create a socket
int create_socket() {
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("socket");
        exit(EXIT_FAILURE);
    }
    return sockfd;
}

// Bind the socket to a port
void bind_socket(int sockfd, int port) {
    struct sockaddr_in addr;
    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = INADDR_ANY;
    addr.sin_port = htons(port);
    if (bind(sockfd, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
        perror("bind");
        exit(EXIT_FAILURE);
    }
}

// Listen for incoming connections
void listen_for_connections(int sockfd) {
    if (listen(sockfd, MAX_CLIENTS) < 0) {
        perror("listen");
        exit(EXIT_FAILURE);
    }
}

// Accept an incoming connection
int accept_connection(int sockfd) {
    int clientfd;
    struct sockaddr_in addr;
    socklen_t addrlen = sizeof(addr);
    if ((clientfd = accept(sockfd, (struct sockaddr *)&addr, &addrlen)) < 0) {
        perror("accept");
        exit(EXIT_FAILURE);
    }
    return clientfd;
}

// Send a message to a client
void send_message(int clientfd, char *message) {
    if (send(clientfd, message, strlen(message), 0) < 0) {
        perror("send");
        exit(EXIT_FAILURE);
    }
}

// Receive a message from a client
void receive_message(int clientfd, char *buffer) {
    if (recv(clientfd, buffer, MAX_MESSAGE_LENGTH, 0) < 0) {
        perror("recv");
        exit(EXIT_FAILURE);
    }
}

// Close a client connection
void close_connection(int clientfd) {
    close(clientfd);
}

// Main function
int main() {
    // Create a socket
    int sockfd = create_socket();

    // Bind the socket to a port
    bind_socket(sockfd, PORT);

    // Listen for incoming connections
    listen_for_connections(sockfd);

    // Accept an incoming connection
    int clientfd = accept_connection(sockfd);

    // Send a message to the client
    send_message(clientfd, "Hello, world!\n");

    // Receive a message from the client
    char buffer[MAX_MESSAGE_LENGTH];
    receive_message(clientfd, buffer);

    // Print the message from the client
    printf("Message from client: %s\n", buffer);

    // Close the client connection
    close_connection(clientfd);

    // Close the server socket
    close(sockfd);

    return 0;
}