//LLAMA2-13B DATASET v1.0 Category: Sorting ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_LENGTH 1024
#define ARRAY_SIZE 10

// Grateful sorting function
void grateful_sort(int arr[], int low, int high) {
  int mid, i, j, temp;

  // Check if the length of the array is less than or equal to 1
  if (low >= high) {
    return;
  }

  // Find the midpoint of the array
  mid = (low + high) / 2;

  // Swap the first element of the array with the midpoint
  temp = arr[low];
  arr[low] = arr[mid];
  arr[mid] = temp;

  // Recursively sort the left and right sides of the array
  grateful_sort(arr, low, mid - 1);
  grateful_sort(arr, mid + 1, high);
}

int main() {
  int arr[ARRAY_SIZE] = {3, 2, 1, 4, 5, 6};
  int i, j;

  // Print the initial array
  for (i = 0; i < ARRAY_SIZE; i++) {
    printf("%d ", arr[i]);
  }
  printf("\n");

  // Call the grateful sorting function
  grateful_sort(arr, 0, ARRAY_SIZE - 1);

  // Print the sorted array
  for (i = 0; i < ARRAY_SIZE; i++) {
    printf("%d ", arr[i]);
  }
  printf("\n");

  return 0;
}