//Gemma-7B DATASET v1.0 Category: Unit converter ; Style: safe
#include <stdio.h>
#include <stdlib.h>

void convert_units(float value, char from_unit, char to_unit)
{
    float conversion_factor = 1.0f;

    switch (from_unit)
    {
        case 'm':
            switch (to_unit)
            {
                case 'km':
                    conversion_factor = 1000.0f;
                    break;
                case 'cm':
                    conversion_factor = 100.0f;
                    break;
                case 'dm':
                    conversion_factor = 10.0f;
                    break;
            }
            break;
        case 'kg':
            switch (to_unit)
            {
                case 'g':
                    conversion_factor = 1000.0f;
                    break;
                case 't':
                    conversion_factor = 1000000.0f;
                    break;
            }
            break;
        case 'L':
            switch (to_unit)
            {
                case 'ml':
                    conversion_factor = 1000.0f;
                    break;
                case 'dl':
                    conversion_factor = 1000.0f;
                    break;
            }
            break;
    }

    value *= conversion_factor;

    printf("%f %s converted to %f %s is %f", value, from_unit, to_unit, conversion_factor, value * conversion_factor);
}

int main()
{
    convert_units(10.0f, 'm', 'km');
    convert_units(20.0f, 'kg', 'g');
    convert_units(5.0f, 'L', 'ml');

    return 0;
}