//LLAMA2-13B DATASET v1.0 Category: Math exercise ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Complex number structure
typedef struct {
    double real;
    double imag;
} complex;

// Function to add two complex numbers
complex add(complex a, complex b) {
    return (complex) {
        a.real + b.real - a.imag * b.imag,
        a.imag + b.imag + a.real * b.real
    };
}

// Function to multiply two complex numbers
complex mult(complex a, complex b) {
    return (complex) {
        a.real * b.real - a.imag * b.imag,
        a.real * b.imag + a.imag * b.real
    };
}

// Function to calculate the modulus of a complex number
double mod(complex z) {
    return sqrt(z.real * z.real + z.imag * z.imag);
}

// Function to calculate the argument of a complex number
double arg(complex z) {
    return atan2(z.imag, z.real);
}

int main() {
    complex a = {2.0, 3.0};
    complex b = {4.0, 5.0};
    complex c = add(a, b);
    complex d = mult(a, b);
    double mod_c = mod(c);
    double arg_c = arg(c);
    double mod_d = mod(d);
    double arg_d = arg(d);

    printf("a + b = %f + %fi\n", c.real, c.imag);
    printf("a * b = %f + %fi\n", d.real, d.imag);
    printf("|c| = %f\n", mod_c);
    printf("arg(c) = %f\n", arg_c);
    printf("|d| = %f\n", mod_d);
    printf("arg(d) = %f\n", arg_d);

    return 0;
}