//Falcon-180B DATASET v1.0 Category: Graph Coloring Problem ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define VERTEX_COUNT 6
#define COLOR_COUNT 3

int graph[VERTEX_COUNT][VERTEX_COUNT] = {
    { 0, 1, 0, 1, 0, 0 },
    { 1, 0, 1, 0, 1, 0 },
    { 0, 1, 0, 1, 0, 1 },
    { 1, 0, 1, 0, 0, 1 },
    { 0, 1, 0, 0, 1, 0 },
    { 0, 0, 1, 1, 0, 0 }
};

int vertex_colors[VERTEX_COUNT] = { 0, 0, 0, 0, 0, 0 };
bool is_valid_color(int vertex, int color) {
    for (int i = 0; i < VERTEX_COUNT; i++) {
        if (graph[vertex][i] && vertex_colors[i] == color) {
            return false;
        }
    }
    return true;
}

void color_vertex(int vertex, int color) {
    vertex_colors[vertex] = color;
}

bool color_graph() {
    int colors[COLOR_COUNT] = { 0, 1, 2 };
    int color_index = 0;
    for (int i = 0; i < VERTEX_COUNT; i++) {
        if (!vertex_colors[i]) {
            for (int j = 0; j < COLOR_COUNT; j++) {
                if (is_valid_color(i, colors[j])) {
                    color_vertex(i, colors[j]);
                    color_index++;
                    break;
                }
            }
        }
    }
    return color_index == COLOR_COUNT;
}

int main() {
    if (color_graph()) {
        printf("Graph successfully colored.\n");
    } else {
        printf("Graph cannot be colored with %d colors.\n", COLOR_COUNT);
    }
    return 0;
}