//GEMINI-pro DATASET v1.0 Category: Levenshtein Distance Calculator ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int min(int a, int b) {
    return a < b ? a : b;
}

int levenshtein(const char *s1, const char *s2) {
    int len1 = strlen(s1);
    int len2 = strlen(s2);

    if (len1 == 0)
        return len2;
    if (len2 == 0)
        return len1;

    int matrix[len1 + 1][len2 + 1];

    for (int i = 0; i <= len1; i++)
        matrix[i][0] = i;
    for (int j = 0; j <= len2; j++)
        matrix[0][j] = j;

    for (int i = 1; i <= len1; i++) {
        for (int j = 1; j <= len2; j++) {
            int cost = s1[i - 1] == s2[j - 1] ? 0 : 1;
            matrix[i][j] = min(
                matrix[i - 1][j] + 1,        // deletion
                min(
                    matrix[i][j - 1] + 1,    // insertion
                    matrix[i - 1][j - 1] + cost // substitution
                )
            );
        }
    }

    return matrix[len1][len2];
}

int main(void) {
    char *s1 = "abcd";
    char *s2 = "bcde";

    int distance = levenshtein(s1, s2);

    printf("The Levenshtein distance between '%s' and '%s' is %d.\n", s1, s2, distance);

    return 0;
}