//GPT-4o-mini DATASET v1.0 Category: Modern Encryption ; Style: creative
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <openssl/aes.h>
#include <openssl/rand.h>

// Function to print the bytes in hex format
void print_hex(const unsigned char* buf, size_t len) {
    for (size_t i = 0; i < len; i++) {
        printf("%02x", buf[i]);
    }
    printf("\n");
}

// Function to encrypt a plaintext message
void encrypt(unsigned char* plaintext, unsigned char* key, unsigned char* ciphertext) {
    AES_KEY enc_key;
    AES_set_encrypt_key(key, 128, &enc_key);
    AES_encrypt(plaintext, ciphertext, &enc_key);
}

// Function to decrypt ciphertext back to plaintext
void decrypt(unsigned char* ciphertext, unsigned char* key, unsigned char* decryptedtext) {
    AES_KEY dec_key;
    AES_set_decrypt_key(key, 128, &dec_key);
    AES_decrypt(ciphertext, decryptedtext, &dec_key);
}

// Function to generate a random key
void generate_random_key(unsigned char* key, size_t length) {
    if (!RAND_bytes(key, length)) {
        fprintf(stderr, "Error generating random key\n");
        exit(1);
    }
}

int main() {
    unsigned char key[16]; // AES-128 key size
    unsigned char plaintext[16] = "Hello, World!!";
    unsigned char ciphertext[16];
    unsigned char decryptedtext[16];

    // Generating a random key
    generate_random_key(key, sizeof(key));
    
    printf("Generated Key: ");
    print_hex(key, sizeof(key));

    // Encrypting the plaintext
    printf("Plaintext: ");
    print_hex(plaintext, sizeof(plaintext));
    
    encrypt(plaintext, key, ciphertext);

    // Displaying encrypted ciphertext
    printf("Ciphertext: ");
    print_hex(ciphertext, sizeof(ciphertext));

    // Decrypting the ciphertext
    decrypt(ciphertext, key, decryptedtext);

    // Displaying decrypted text
    printf("Decrypted text: ");
    print_hex(decryptedtext, sizeof(decryptedtext));

    // Verifying if decryption was successful
    if (strncmp((char*)plaintext, (char*)decryptedtext, sizeof(plaintext)) == 0) {
        printf("Success! Decryption matched the original plaintext.\n");
    } else {
        printf("Error! Decryption did not match the original plaintext.\n");
    }

    return 0;
}