//GPT-4o-mini DATASET v1.0 Category: Intrusion detection system ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

// The Intrusion Detection System's poetic soul
// In the realm of code where the shadows lay,
// We whisper to detect the rogue's foul play.
// A guardian of logs, a sentry of light,
// With every intrusion, we'll raise up the fight.

// Log file path for tracking the unauthorized
#define LOG_FILE "intrusion_logs.txt"

// Function to get the current time as a string
void get_current_time(char *buffer, size_t size) {
    time_t now = time(NULL);
    struct tm *tm_info = localtime(&now);
    strftime(buffer, size, "%Y-%m-%d %H:%M:%S", tm_info);
}

// Function to log intrusion attempts
void log_intrusion(const char *ip_address) {
    char time_buffer[20];
    get_current_time(time_buffer, sizeof(time_buffer));
    
    FILE *log_file = fopen(LOG_FILE, "a");
    if (log_file == NULL) {
        perror("Unable to open log file");
        exit(EXIT_FAILURE);
    }
    
    fprintf(log_file, "[%s] Intrusion detected from IP: %s\n", time_buffer, ip_address);
    fclose(log_file);
}

// A mock function to simulate an active server monitoring environment
// Where rogue entities may choose to tread
void monitor_server() {
    char rogue_ips[][16] = {"192.168.1.10", "172.16.0.20", "10.0.0.100", "203.0.113.5"};
    int num_of_rogues = sizeof(rogue_ips) / sizeof(rogue_ips[0]);
    
    printf("Monitoring the realm, stay alert my friend!\n");
    sleep(2); // Simulating the passage of time
    
    // Simulating the rogue access attempts
    for (int i = 0; i < num_of_rogues; i++) {
        printf("Alert! Possible intrusion from %s...\n", rogue_ips[i]);
        log_intrusion(rogue_ips[i]);
        sleep(1);
    }
    
    printf("Monitoring concluded, logs have been written away.\n");
}

int main() {
    // The gateway to our vigilant domain
    printf("Welcome to the Artistic Intrusion Detection System!\n");
    printf("Engaging the watchful eyes...\n\n");
    
    // Start monitoring for intrusions
    monitor_server();
    
    // Farewell to the watchmen of code
    printf("End of the watch; may peace reign upon this code.\n");
    return 0;
}