//Gemma-7B DATASET v1.0 Category: Public-Key Algorithm Implementation ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MOD 23

int main()
{

    // Generate a random number between 1 and MOD-1
    srand(time(NULL));
    int n = rand() % (MOD - 1) + 1;

    // Calculate the Euler totient of n
    int totient = phi(n);

    // Choose a random number between 1 and totient-1 as the secret key
    int sk = rand() % totient + 1;

    // Calculate the public key exponent
    int pk = fermat(sk, totient);

    // Print the public key exponent and the modulus
    printf("Public key exponent: %d\n", pk);
    printf("Modulus: %d\n", MOD);

    return 0;
}

int phi(int n)
{
    int i, totient = 1;

    for (i = 2; i * i <= n; i++)
    {
        if (n % i == 0)
        {
            totient -= i;
            n /= i;
        }
    }

    if (n > 1)
    {
        totient -= n;
    }

    return totient;
}

int fermat(int a, int n)
{
    int i, result = 1;

    for (i = 0; i < n; i++)
    {
        result = (result * a) % n;
    }

    return result;
}