//Falcon2-11B DATASET v1.0 Category: Data structures visualization ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>

void visualize(int num_nodes, int* graph) {
    for (int i = 0; i < num_nodes; i++) {
        for (int j = 0; j < num_nodes; j++) {
            printf("%s", graph[i] == j? "|" : " ");
        }
        printf("\n");
    }
}

int main() {
    int num_nodes = 6;
    int graph[num_nodes][num_nodes];

    // Create the graph
    graph[0][1] = 1;
    graph[0][2] = 1;
    graph[1][0] = 1;
    graph[1][2] = 1;
    graph[2][0] = 1;
    graph[2][1] = 1;

    // Visualize the graph
    visualize(num_nodes, graph);

    // Run the graph as a child process
    int pid = fork();
    if (pid == 0) {
        // Child process
        for (int i = 0; i < num_nodes; i++) {
            for (int j = 0; j < num_nodes; j++) {
                printf("%d", graph[i][j]);
            }
            printf("\n");
        }
        exit(0);
    } else if (pid > 0) {
        // Parent process
        waitpid(pid, NULL, 0);
    }

    return 0;
}