//LLAMA2-13B DATASET v1.0 Category: Unit converter ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define MAX_UNITS 10
#define MAX_CONVERTIONS 5

typedef struct {
    char *name;
    double value;
} unit_t;

unit_t units[MAX_UNITS] = {
    {"inch", 0.0254},
    {"foot", 0.3048},
    {"yard", 0.9144},
    {"mile", 1609.344},
    {"kilogram", 0.001},
    {"gram", 0.001},
    {"pound", 0.453592},
    {"ounce", 0.0283495},
    {"stone", 0.157473},
    {"ton", 1000.0}
};

int main() {
    char input[100];
    char output[100];
    int i, j;
    double value;

    printf("Welcome to the Unit Converter!\n");

    // Convert from one unit to another
    printf("Enter the value you want to convert: ");
    fgets(input, 100, stdin);
    value = atof(input);

    for (i = 0; i < MAX_UNITS; i++) {
        if (strcmp(units[i].name, "all") == 0) {
            for (j = 0; j < MAX_CONVERTIONS; j++) {
                if (strcmp(units[j].name, "none") == 0) {
                    continue;
                }

                sprintf(output, "%s is %s", units[i].name, units[j].name);
                printf("%s\n", output);

                value = value * units[j].value / units[i].value;
                sprintf(output, "%.2f %s = %f %s", units[i].name, units[j].name, value, units[j].name);
                printf("%s\n", output);
            }
            break;
        }
    }

    return 0;
}