//Falcon-180B DATASET v1.0 Category: Database querying ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LEN 100
#define MAX_AGE 120

typedef struct {
    char name[MAX_NAME_LEN];
    int age;
} Person;

int compare_name(const void *a, const void *b) {
    const char *name_a = ((const Person *)a)->name;
    const char *name_b = ((const Person *)b)->name;
    return strcmp(name_a, name_b);
}

int compare_age(const void *a, const void *b) {
    const Person *person_a = (const Person *)a;
    const Person *person_b = (const Person *)b;
    return person_a->age - person_b->age;
}

void print_person(const Person *person) {
    printf("Name: %s, Age: %d\n", person->name, person->age);
}

int main() {
    // Initialize an array of people
    Person people[] = {{"Alice", 25}, {"Bob", 30}, {"Charlie", 35}, {"David", 40}};
    int num_people = sizeof(people) / sizeof(people[0]);

    // Sort the array by name
    qsort(people, num_people, sizeof(people[0]), compare_name);

    // Print the sorted array
    for (int i = 0; i < num_people; i++) {
        print_person(&people[i]);
    }

    // Sort the array by age
    qsort(people, num_people, sizeof(people[0]), compare_age);

    // Print the sorted array
    for (int i = 0; i < num_people; i++) {
        print_person(&people[i]);
    }

    return 0;
}