//GEMINI-pro DATASET v1.0 Category: Website Uptime Monitor ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

// Custom data structure to hold website information
typedef struct website {
    char *url;
    time_t last_checked;
    int status_code;
} website_t;

// Callback function to handle website response
size_t write_response(char *ptr, size_t size, size_t nmemb, void *userdata) {
    website_t *website = (website_t *)userdata;

    // Update the website's last checked time and status code
    website->last_checked = time(NULL);
    website->status_code = atoi(ptr);

    return size * nmemb;
}

// Function to check the uptime of a website
int check_uptime(website_t *website) {
    CURL *curl;
    CURLcode res;

    // Initialize the cURL library
    curl = curl_easy_init();
    if (!curl) {
        fprintf(stderr, "Failed to initialize cURL\n");
        return EXIT_FAILURE;
    }

    // Set the URL to check
    curl_easy_setopt(curl, CURLOPT_URL, website->url);

    // Set the write callback function
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_response);

    // Set the user data pointer
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, website);

    // Perform the request
    res = curl_easy_perform(curl);
    if (res != CURLE_OK) {
        fprintf(stderr, "Failed to perform cURL request: %s\n", curl_easy_strerror(res));
        curl_easy_cleanup(curl);
        return EXIT_FAILURE;
    }

    curl_easy_cleanup(curl);

    // Return the status code of the request
    return website->status_code;
}

// Function to print the uptime of a website
void print_uptime(website_t *website) {
    time_t now = time(NULL);
    long uptime = now - website->last_checked;

    printf("%s: %d seconds uptime\n", website->url, uptime);
}

int main() {
    // Create an array of websites to monitor
    website_t websites[] = {
        { .url = "https://google.com" },
        { .url = "https://facebook.com" },
        { .url = "https://twitter.com" },
    };

    // Check the uptime of each website
    for (int i = 0; i < sizeof(websites) / sizeof(website_t); i++) {
        int status_code = check_uptime(&websites[i]);
        if (status_code == 200) {
            print_uptime(&websites[i]);
        } else {
            printf("%s: Website down (status code %d)\n", websites[i].url, status_code);
        }
    }

    return EXIT_SUCCESS;
}