//GPT-4o-mini DATASET v1.0 Category: Digital Watermarking ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>

#define WIDTH 5
#define HEIGHT 5

// Function to print the image
void printImage(uint8_t image[HEIGHT][WIDTH]) {
    printf("Current Image:\n");
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            printf("%3d ", image[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}

// Function to embed watermark into the image
void embedWatermark(uint8_t image[HEIGHT][WIDTH], uint8_t watermark[HEIGHT][WIDTH]) {
    printf("Embedding Watermark...\n");
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            // Embed the watermark in the least significant bit
            image[i][j] = (image[i][j] & ~1) | (watermark[i][j] & 1);
        }
    }
    printf("Watermark Embedded!\n");
}

// Function to extract watermark from the image
void extractWatermark(uint8_t image[HEIGHT][WIDTH], uint8_t watermark[HEIGHT][WIDTH]) {
    printf("Extracting Watermark...\n");
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            // Extract the watermark from the least significant bit
            watermark[i][j] = image[i][j] & 1;
        }
    }
    printf("Watermark Extracted!\n");
}

// Main function
int main() {
    // Create an example grayscale image and watermark
    uint8_t image[HEIGHT][WIDTH] = {
        {100, 150, 200, 250, 255},
        {50, 80, 120, 180, 240},
        {30, 60, 90, 120, 150},
        {10, 20, 30, 40, 50},
        {5, 10, 15, 20, 25}
    };

    uint8_t watermark[HEIGHT][WIDTH] = {
        {0, 1, 0, 1, 0},
        {1, 0, 1, 0, 1},
        {0, 1, 0, 1, 0},
        {1, 0, 1, 0, 1},
        {0, 1, 0, 1, 0}
    };

    // Print the original image
    printImage(image);

    // Embed the watermark in the image
    embedWatermark(image, watermark);
    printImage(image); // Print modified image

    // Create a placeholder for extracted watermark
    uint8_t extractedWatermark[HEIGHT][WIDTH] = {0};

    // Extract the watermark from the modified image
    extractWatermark(image, extractedWatermark);
    
    // Print the extracted watermark
    printf("Extracted Watermark:\n");
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            printf("%3d ", extractedWatermark[i][j]);
        }
        printf("\n");
    }

    // Goodbye message to the user
    printf("\nYay! Watermarking is fun! 🎉\n");
    return 0;
}