//GPT-4o-mini DATASET v1.0 Category: Metadata Extractor ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <jpeglib.h>
#include <stdint.h>

void extract_jpeg_metadata(const char *filename) {
    struct jpeg_decompress_struct cinfo;
    struct jpeg_error_mgr jerr;

    FILE *infile;
    if ((infile = fopen(filename, "rb")) == NULL) {
        fprintf(stderr, "Cannot open %s\n", filename);
        return;
    }

    cinfo.err = jpeg_std_error(&jerr);
    jpeg_create_decompress(&cinfo);
    jpeg_stdio_src(&cinfo, infile);
    jpeg_read_header(&cinfo, TRUE);
    
    printf("JPEG image metadata:\n");
    printf("  Format: JPEG\n");
    printf("  Width: %d pixels\n", cinfo.image_width);
    printf("  Height: %d pixels\n", cinfo.image_height);
    printf("  Number of color components: %d\n", cinfo.num_components);
    
    // Display color space information
    switch (cinfo.jpeg_color_space) {
        case JCS_GRAYSCALE:
            printf("  Color Space: Grayscale\n");
            break;
        case JCS_RGB:
            printf("  Color Space: RGB\n");
            break;
        case JCS_YCbCr:
            printf("  Color Space: YCbCr\n");
            break;
        case JCS_CMYK:
            printf("  Color Space: CMYK\n");
            break;
        default:
            printf("  Color Space: Unknown\n");
            break;
    }

    jpeg_destroy_decompress(&cinfo);
    fclose(infile);
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <filename.jpg>\n", argv[0]);
        return EXIT_FAILURE;
    }

    extract_jpeg_metadata(argv[1]);

    return EXIT_SUCCESS;
}