//GEMINI-pro DATASET v1.0 Category: Stock market tracker ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of stocks to track
#define MAX_STOCKS 10

// Define the structure of a stock
typedef struct {
    char symbol[10];
    double price;
    double change;
} Stock;

// Define the array of stocks to track
Stock stocks[MAX_STOCKS];

// Define the function to print the stock information
void print_stock(Stock stock) {
    printf("%s: $%.2f (%.2f%%)\n", stock.symbol, stock.price, stock.change);
}

// Define the function to update the stock information
void update_stock(Stock *stock, double price, double change) {
    stock->price = price;
    stock->change = change;
}

// Define the main function
int main() {
    // Initialize the array of stocks
    strcpy(stocks[0].symbol, "AAPL");
    stocks[0].price = 170.50;
    stocks[0].change = 1.23;

    strcpy(stocks[1].symbol, "GOOG");
    stocks[1].price = 1200.00;
    stocks[1].change = 0.54;

    strcpy(stocks[2].symbol, "MSFT");
    stocks[2].price = 275.00;
    stocks[2].change = -0.32;

    // Print the initial stock information
    printf("Initial stock information:\n");
    for (int i = 0; i < MAX_STOCKS; i++) {
        print_stock(stocks[i]);
    }

    // Update the stock information
    update_stock(&stocks[0], 171.00, 1.29);
    update_stock(&stocks[1], 1205.00, 0.42);
    update_stock(&stocks[2], 274.50, -0.18);

    // Print the updated stock information
    printf("\nUpdated stock information:\n");
    for (int i = 0; i < MAX_STOCKS; i++) {
        print_stock(stocks[i]);
    }

    return 0;
}