//GPT-4o-mini DATASET v1.0 Category: Secure Password Generator ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define PASSWORD_LENGTH 16
#define NUMBER_OF_PASSWORDS 5

const char *lowercase = "abcdefghijklmnopqrstuvwxyz";
const char *uppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
const char *digits = "0123456789";
const char *special_characters = "!@#$%^&*()-_=+[]{}|;:,.<>?";

void generate_password(char *password) {
    int i;
    int total_chars = strlen(lowercase) + strlen(uppercase) + strlen(digits) + strlen(special_characters);

    // Ensure the password contains at least one character from each character set
    password[0] = lowercase[rand() % strlen(lowercase)];
    password[1] = uppercase[rand() % strlen(uppercase)];
    password[2] = digits[rand() % strlen(digits)];
    password[3] = special_characters[rand() % strlen(special_characters)];

    // Fill the rest of the password with random characters from all sets
    for (i = 4; i < PASSWORD_LENGTH; i++) {
        int random_index = rand() % total_chars;

        if (random_index < strlen(lowercase)) {
            password[i] = lowercase[random_index];
        } else if (random_index < strlen(lowercase) + strlen(uppercase)) {
            password[i] = uppercase[random_index - strlen(lowercase)];
        } else if (random_index < strlen(lowercase) + strlen(uppercase) + strlen(digits)) {
            password[i] = digits[random_index - (strlen(lowercase) + strlen(uppercase))];
        } else {
            password[i] = special_characters[random_index - (strlen(lowercase) + strlen(uppercase) + strlen(digits))];
        }
    }

    // Shuffle the password to ensure randomness
    for (i = 0; i < PASSWORD_LENGTH; i++) {
        int random_index = rand() % PASSWORD_LENGTH;
        char temp = password[i];
        password[i] = password[random_index];
        password[random_index] = temp;
    }

    password[PASSWORD_LENGTH] = '\0'; // Ensure null-termination
}

int main() {
    // Seed the random number generator
    srand(time(NULL));

    char passwords[NUMBER_OF_PASSWORDS][PASSWORD_LENGTH + 1]; // Array to store multiple passwords
    int i;

    printf("Generating %d secure passwords...\n", NUMBER_OF_PASSWORDS);
    for (i = 0; i < NUMBER_OF_PASSWORDS; i++) {
        generate_password(passwords[i]);
        printf("Password %d: %s\n", i + 1, passwords[i]);
    }

    return 0;
}