//GEMINI-pro DATASET v1.0 Category: Searching algorithm ; Style: irregular
#include <stdio.h>
#include <stdlib.h>

// Function to search for an element in an array using linear search
int linear_search(int arr[], int n, int target) {
    for (int i = 0; i < n; i++) {
        if (arr[i] == target) {
            return i;
        }
    }

    return -1;
}

// Function to search for an element in an array using binary search
int binary_search(int arr[], int n, int target) {
    int low = 0;
    int high = n - 1;

    while (low <= high) {
        int mid = (low + high) / 2;

        if (arr[mid] == target) {
            return mid;
        } else if (arr[mid] < target) {
            low = mid + 1;
        } else {
            high = mid - 1;
        }
    }

    return -1;
}

// Driver code
int main() {
    // Array of integers
    int arr[] = {1, 3, 5, 7, 9, 11, 13, 15, 17, 19};
    int n = sizeof(arr) / sizeof(arr[0]);

    // Target element to search for
    int target = 11;

    // Search for the element using linear search
    int result = linear_search(arr, n, target);
    if (result == -1) {
        printf("Element not found using linear search!\n");
    } else {
        printf("Element found at index %d using linear search!\n", result);
    }

    // Search for the element using binary search
    result = binary_search(arr, n, target);
    if (result == -1) {
        printf("Element not found using binary search!\n");
    } else {
        printf("Element found at index %d using binary search!\n", result);
    }

    return 0;
}